//	mydlg.cpp  -  catalog send dialog sample code
//
//	This is a part of the MetaKit library.
//	Copyright (c) 1996 Meta Four Software.
//	All rights reserved.
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CatSend.h"
#include "MyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyDlg dialog

CMyDlg::CMyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CMyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyDlg)
	DDX_Control(pDX, IDC_ADDRESS, m_address);
	DDX_Control(pDX, IDC_PORT, m_port);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyDlg, CDialog)
	//{{AFX_MSG_MAP(CMyDlg)
	ON_BN_CLICKED(IDC_SEND_BTN, OnSendBtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// [JCW]  This code added for MetaKit CATSEND

BOOL CMyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_address.SetWindowText("127.0.0.1");
	m_port.SetWindowText("12345");
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

	// the following lines show how easy it is to become a TCP/IP client
void CMyDlg::OnSendBtn() 
{
	CString s;
	m_port.GetWindowText(s);
	int port = atoi(s);

	CString address;
	m_address.GetWindowText(address);

	CFileDialog dlg (TRUE, NULL, "*.*");
	if (port > 0 && dlg.DoModal() == IDOK)
	{
		CSocket client;
		VERIFY(client.Create());
		
		if (client.Connect(address, port))
		{
			CSocketFile stream (&client);

				// use the data file without knowing its structure
			c4_Storage storage (dlg.GetPathName(), false);
			storage.SaveToStream(&stream);
		}
		else
			AfxMessageBox("Could not connect to the CATRECV server.");
	}
}

/////////////////////////////////////////////////////////////////////////////
